![[Pasted image 20250428135504.png]]
## Introduction

- **Challenges**:
    - Improper web use costs businesses billions annually in lost productivity and legal risks.
    - Legacy URL filtering solutions are ineffective against the dynamic web, with over 80% of content uncategorized.
    - Over 500,000 new websites are added daily, with 30% of domains changing annually.
- **Solution**:
    - Cisco Secure Web Appliance provides policy-based web access controls to balance security, productivity, and acceptable use.

---

## Web Usage Controls

![[Pasted image 20250427120058.png]]

### **Engines for Inspecting Web Traffic**:

1. **URL Filtering**:
    - Controls access to websites based on their category and reputation.
    - Categorizes websites into predefined (85 categories) and custom URL groups.
2. **Application Visibility and Control (AVC)**:
    - Manages applications and micro-applications (e.g., Facebook chat, games).
    - Enables actions like blocking, monitoring, restricting, or bandwidth limiting.
3. **Dynamic Content Analysis (DCA)**:
    - Provides real-time categorization for unknown or objectionable content.
    - Covers the dark web and dynamic content like blogs and social networks.

---

## URL Filtering

- **Purpose**:
    - Improves productivity by blocking non-business web use.
    - Reduces bandwidth costs and ensures regulatory compliance.
    - Enforces corporate policies while protecting organizations from legal liability.
- **Actions**:
    - **Block**: Denies access to URLs in specific categories.
    - **Allow**: Grants access to trusted websites but bypasses further filtering.
    - **Monitor**: Logs access without enforcing restrictions.
    - **Warn**: Displays a warning before granting access.
    - **Quota-Based**: Limits time or data usage for specific categories.
    - **Time-Based**: Controls access during specific time ranges (e.g., working hours).
    - **Redirect**: Redirects traffic to another site for specific URLs or categories.

---

### URL Categories

1. **Predefined Categories**:
    - 85 categories, including Gambling, Social Networking, Shopping, Finance, etc.
    - Constantly updated by Cisco for accuracy and relevance.
2. **Custom Categories**:
    - Allows organizations to group internal or external websites for specific actions.
    - Useful for uncategorized URLs or exceptions to predefined rules.
3. **Uncategorized URLs**:
    - Treated as a separate predefined category.
    - Can be grouped into custom categories for better control.

---

## Dynamic Content Analysis (DCA) Engine

- **Purpose**:
    - Fills the gap left by list-based URL filtering.
    - Dynamically categorizes up to 90% of objectionable dark web content.
- **How It Works**:
    - Three-step categorization process:
        1. Check against Cisco’s URL category database.
        2. Analyze the URL keyword/URI for categorization.
        3. Use DCA for real-time categorization if the previous steps fail.
    - Updates every 5 minutes via Cisco Talos security intelligence.
- **Benefits**:
    - Covers dynamic and hidden content like blogs and SSL traffic.
    - Reduces liability and compliance risks with minimal false positives.

---

## Application Visibility and Control (AVC)

- **Purpose**:
    - Provides granular control over web applications and micro-applications.
    - Inspects web transactions to enforce acceptable use policies.
- **Capabilities**:
    - Control application behavior (e.g., restrict file transfers in messaging apps).
    - Limit bandwidth usage for streaming media or specific applications.
    - Block or monitor instant messaging, blogging, and social media apps.
    - Notify users when blocked from using certain applications.
- **Actions**:
    - **Block**: Denies application access and displays a notification.
    - **Monitor**: Logs usage without enforcing restrictions.
    - **Restrict**: Blocks specific behaviors within applications (e.g., file uploads).
    - **Bandwidth Limit**: Throttles traffic for high-bandwidth applications.
- **Examples**:
    - Allow Facebook access but block chat and games within Facebook.
    - Permit media streaming but limit its bandwidth usage.

---

## Safe Search and Adult Content Filtering

- **Purpose**:
    - Prevents users from accessing adult or explicit content via search engines and websites.
- **Features**:
    1. **Safe Search**:
        - Filters out unsafe content in search results from supported engines (e.g., Google, Bing, Yahoo).
        - Blocks access if safe search enforcement fails.
    2. **Site Content Rating**:
        - Blocks access to adult-oriented or explicit content on supported sites (e.g., YouTube, Flickr).
- **Implementation**:
    - Enabled at the access policy level.
    - Provides centralized control to prevent bypassing acceptable-use policies.

---

## Bandwidth Limitation

- **Purpose**:
    - Controls bandwidth usage for high-traffic sites and applications (e.g., YouTube, Facebook).
- **Types**:
    1. **Overall Bandwidth Limit**:
        - Applies across all users, throttling traffic to specific applications.
    2. **User Bandwidth Limit**:
        - Restricts bandwidth for individual users.
- **Example**:
    - Limit Facebook video traffic to 1 Mbps per user to conserve network resources.

---

## Access Policies for Acceptable Use

### **Custom Policies**:

- Allow organizations to apply different actions to web traffic based on user roles, applications, URL categories, and time.
- Examples:
    1. **Block Gambling Websites**:
        - Matches all users and denies access to Gambling category URLs.
    2. **Limit Social Networking Access**:
        - Allows access to social networking websites during non-working hours.
        - Limits bandwidth for Facebook micro-applications (e.g., games, chat).
    3. **Allow Banking Websites**:
        - Grants unrestricted access to Finance category URLs for authenticated users.
- **Global Policy**:
    - Applies to unmatched web transactions.
    - Ensures a baseline level of control.

---

## Key Takeaways

- **Web Usage Controls**:
    - URL filtering, DCA, and AVC engines provide layered, real-time control over web traffic.
    - DCA covers dark web content and uncategorized URLs, enhancing filtering effectiveness.
- **Acceptable Use Policies**:
    - Enforce corporate policies, improve productivity, and reduce legal risks.
    - Custom and predefined URL categories provide flexibility in managing web access.
- **Bandwidth Management**:
    - Throttle high-bandwidth applications to optimize network performance.
- **Safe Search**:
    - Ensures users cannot bypass acceptable-use policies on search engines.